/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore;

import com.tmtravlr.potioncore.ConfigLoader;
import com.tmtravlr.potioncore.PotionCore;
import com.tmtravlr.potioncore.PotionCoreAttributes;
import com.tmtravlr.potioncore.PotionCoreEffects;
import com.tmtravlr.potioncore.PotionCoreHelper;
import com.tmtravlr.potioncore.PotionCoreTeleporter;
import com.tmtravlr.potioncore.PotionCoreTypes;
import com.tmtravlr.potioncore.network.SToCMessage;
import com.tmtravlr.potioncore.potion.PotionAntidote;
import com.tmtravlr.potioncore.potion.PotionDrown;
import com.tmtravlr.potioncore.potion.PotionFlight;
import com.tmtravlr.potioncore.potion.PotionPotionSickness;
import com.tmtravlr.potioncore.potion.PotionPurity;
import com.tmtravlr.potioncore.potion.PotionRecoil;
import com.tmtravlr.potioncore.potion.PotionRevival;
import com.tmtravlr.potioncore.potion.PotionSlowfall;
import com.tmtravlr.potioncore.potion.PotionStepup;
import com.tmtravlr.potioncore.potion.PotionTeleportSpawn;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="potioncore")
public class PotionCoreEventHandler {
    private static final Object INVUL_RESET_LOCK = new Object();

    @SubscribeEvent
    public static void onRegisterPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        PotionCoreEffects.loadPotionEffects((IForgeRegistry<Potion>)registry);
    }

    @SubscribeEvent
    public static void onRegisterPotionTypes(RegistryEvent.Register<PotionType> event) {
        IForgeRegistry registry = event.getRegistry();
        PotionCoreTypes.loadPotionTypes((IForgeRegistry<PotionType>)registry);
    }

    @SubscribeEvent
    public static void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.PROJECTILE_DAMAGE);
            ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.MAGIC_DAMAGE);
            ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.JUMP_HEIGHT);
            ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.DAMAGE_RESISTANCE);
            ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.MAGIC_SHIELDING);
            if (event.getEntity() instanceof EntityPlayer) {
                ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.STEP_HEIGHT);
                ((EntityLivingBase)event.getEntity()).func_110140_aT().func_111150_b(PotionCoreAttributes.DIG_SPEED);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && !PotionCoreHelper.hasServer) {
            return;
        }
        if (ConfigLoader.controllableJumpBoost) {
            double jumpAttribute = event.getEntityLiving().func_110148_a(PotionCoreAttributes.JUMP_HEIGHT).func_111126_e();
            if (event.getEntityLiving().func_70660_b(MobEffects.field_76430_j) != null) {
                double jumpBoost = event.getEntityLiving().func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1;
                event.getEntityLiving().field_70181_x -= jumpBoost / 10.0;
            }
            if (!(event.getEntityLiving() instanceof EntityPlayer) || jumpAttribute <= 1.0) {
                event.getEntityLiving().field_70181_x = Math.sqrt(0.1764 * jumpAttribute);
            } else if (event.getEntityLiving().field_70170_p.field_72995_K) {
                event.getEntityLiving().getEntityData().func_74780_a("Potion Core - Jump Boost Height", jumpAttribute);
                event.getEntityLiving().getEntityData().func_74780_a("Potion Core - Jump Boost Base", event.getEntityLiving().field_70163_u);
                event.getEntityLiving().getEntityData().func_74757_a("Potion Core - Jump Boost Jumping", true);
            }
        } else {
            float jump = (float)PotionCoreAttributes.getAdjustedJumpHeightAttribute(event.getEntityLiving()) - 1.0f;
            event.getEntityLiving().field_70181_x += (double)jump / 10.0;
        }
    }

    @SubscribeEvent
    public static void onPlayerDig(PlayerEvent.BreakSpeed event) {
        if (event.getEntity().field_70170_p.field_72995_K && !PotionCoreHelper.hasServer) {
            return;
        }
        float speed = event.getNewSpeed();
        AttributeModifier tempModifier = new AttributeModifier(PotionCoreHelper.TEMP_UUID, "Base", PotionCoreAttributes.getAdjustedDigSpeed((EntityLivingBase)event.getEntityPlayer(), speed) - 1.0, 0);
        event.getEntityPlayer().func_110148_a(PotionCoreAttributes.DIG_SPEED).func_111121_a(tempModifier);
        speed = (float)event.getEntityPlayer().func_110148_a(PotionCoreAttributes.DIG_SPEED).func_111126_e();
        event.getEntityPlayer().func_110148_a(PotionCoreAttributes.DIG_SPEED).func_111124_b(tempModifier);
        event.setNewSpeed(speed);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && !PotionCoreHelper.hasServer) {
            return;
        }
        float jump = (float)PotionCoreAttributes.getAdjustedJumpHeightAttribute(event.getEntityLiving());
        if (jump > 0.0f) {
            event.setDistance(event.getDistance() - jump);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && !PotionCoreHelper.hasServer) {
            return;
        }
        if (!event.getSource().func_151517_h()) {
            AttributeModifier tempModifier;
            EntityLivingBase source;
            float multiplier = 1.0f;
            if (event.getSource().func_76352_a() && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                source = (EntityLivingBase)event.getSource().func_76346_g();
                tempModifier = new AttributeModifier(PotionCoreHelper.TEMP_UUID, "Base", (double)event.getAmount() - 1.0, 0);
                source.func_110148_a(PotionCoreAttributes.PROJECTILE_DAMAGE).func_111121_a(tempModifier);
                event.setAmount((float)source.func_110148_a(PotionCoreAttributes.PROJECTILE_DAMAGE).func_111126_e());
                source.func_110148_a(PotionCoreAttributes.PROJECTILE_DAMAGE).func_111124_b(tempModifier);
            }
            if (event.getSource().func_82725_o() && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                source = (EntityLivingBase)event.getSource().func_76346_g();
                tempModifier = new AttributeModifier(PotionCoreHelper.TEMP_UUID, "Base", (double)event.getAmount() - 1.0, 0);
                source.func_110148_a(PotionCoreAttributes.MAGIC_DAMAGE).func_111121_a(tempModifier);
                event.setAmount((float)source.func_110148_a(PotionCoreAttributes.MAGIC_DAMAGE).func_111126_e());
                source.func_110148_a(PotionCoreAttributes.MAGIC_DAMAGE).func_111124_b(tempModifier);
            }
            if (event.getSource() == DamageSource.field_76379_h && PotionSlowfall.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionSlowfall.INSTANCE)) {
                int level = event.getEntityLiving().func_70660_b((Potion)PotionSlowfall.INSTANCE).func_76458_c();
                if (level > 0) {
                    event.setAmount(-1.0f);
                    return;
                }
                event.setAmount(event.getAmount() * 0.5f);
                if (event.getAmount() > 4.0f) {
                    event.setAmount(4.0f);
                }
            }
            double resistance = PotionCoreAttributes.getAdjustedDamageResistanceAttribute(event.getEntityLiving());
            multiplier = (float)((double)multiplier * (1.0 - resistance));
            if (event.getSource().func_82725_o()) {
                double magicShield = event.getEntityLiving().func_110148_a(PotionCoreAttributes.MAGIC_SHIELDING).func_111126_e();
                multiplier = (float)((double)multiplier * (1.0 - magicShield / 25.0));
            }
            event.setAmount(event.getAmount() * multiplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurtLow(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
            if (PotionRecoil.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionRecoil.INSTANCE) && (!(event.getSource() instanceof EntityDamageSource) || !((EntityDamageSource)event.getSource()).func_180139_w())) {
                float reflectPercent = MathHelper.func_76131_a((float)((float)(event.getEntityLiving().func_70660_b((Potion)PotionRecoil.INSTANCE).func_76458_c() + 1) * PotionRecoil.reflectDamage), (float)PotionRecoil.reflectDamage, (float)(9.0f * PotionRecoil.reflectDamage));
                source.func_70097_a(DamageSource.func_92087_a((Entity)source), event.getAmount() * reflectPercent);
            }
        }
        if (ConfigLoader.separateInvulTimers) {
            Object object = INVUL_RESET_LOCK;
            synchronized (object) {
                if (event.getSource().func_76352_a()) {
                    PotionCoreHelper.invulResetEntities.add(event.getEntityLiving());
                    if (event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Projectile Invulnerability") <= 0) {
                        event.getEntityLiving().getEntityData().func_74768_a("Potion Core - Projectile Invulnerability", event.getEntityLiving().field_70771_an / 2);
                    }
                }
                if (event.getSource().func_82725_o()) {
                    PotionCoreHelper.invulResetEntities.add(event.getEntityLiving());
                    if (event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Magic Invulnerability") <= 0) {
                        event.getEntityLiving().getEntityData().func_74768_a("Potion Core - Magic Invulnerability", event.getEntityLiving().field_70771_an / 2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        PotionCoreEventHandler.checkInvulReset();
        if (ConfigLoader.separateInvulTimers) {
            Object object = INVUL_RESET_LOCK;
            synchronized (object) {
                if (event.getSource().func_76352_a()) {
                    PotionCoreHelper.invulResetEntities.add(event.getEntityLiving());
                    if (event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Projectile Invulnerability") > 0) {
                        event.setCanceled(true);
                        return;
                    }
                }
                if (event.getSource().func_82725_o()) {
                    PotionCoreHelper.invulResetEntities.add(event.getEntityLiving());
                    if (event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Magic Invulnerability") > 0) {
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            event.getEntityLiving().getEntityData().func_74776_a("Potion Core - Health Fix", event.getEntityLiving().func_110143_aJ());
        }
        if (ConfigLoader.separateInvulTimers) {
            int invulTimer = event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Projectile Invulnerability");
            if (invulTimer > 0) {
                event.getEntityLiving().getEntityData().func_74768_a("Potion Core - Projectile Invulnerability", invulTimer - 1);
            }
            if ((invulTimer = event.getEntityLiving().getEntityData().func_74762_e("Potion Core - Magic Invulnerability")) > 0) {
                event.getEntityLiving().getEntityData().func_74768_a("Potion Core - Magic Invulnerability", invulTimer - 1);
            }
        }
        if (PotionDrown.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionDrown.INSTANCE)) {
            if (event.getEntityLiving().func_70613_aW() && event.getEntityLiving() instanceof EntityPlayerMP && event.getEntityLiving().field_70173_aa % 20 == 0) {
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeInt(1);
                out.writeInt(event.getEntity().getEntityData().func_74762_e("potioncore - drown air"));
                SToCMessage packet = new SToCMessage((ByteBuf)out);
                PotionCore.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)event.getEntityLiving());
            }
            event.getEntity().getEntityData().func_74757_a("potioncore - doing drown", true);
        } else if (event.getEntity().getEntityData().func_74767_n("potioncore - doing drown")) {
            event.getEntity().getEntityData().func_74768_a("potioncore - drown air", 300);
        }
        if (PotionAntidote.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionAntidote.INSTANCE)) {
            event.getEntityLiving().func_184589_d(MobEffects.field_76436_u);
        }
        if (PotionPurity.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionPurity.INSTANCE)) {
            event.getEntityLiving().func_184589_d(MobEffects.field_82731_v);
        }
        if (PotionSlowfall.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionSlowfall.INSTANCE) && event.getEntityLiving().func_70660_b((Potion)PotionSlowfall.INSTANCE).func_76458_c() > 0) {
            event.getEntity().field_70143_R = 0.0f;
        }
        if (ConfigLoader.fixBlindness && event.getEntityLiving().func_70644_a(MobEffects.field_76440_q) && event.getEntityLiving() instanceof EntityLiving && ((EntityLiving)event.getEntityLiving()).func_70638_az() != null) {
            int effectLevel = 3 - event.getEntityLiving().func_70660_b(MobEffects.field_76440_q).func_76458_c();
            if (effectLevel < 0) {
                effectLevel = 0;
            }
            if (event.getEntityLiving().func_70032_d((Entity)((EntityLiving)event.getEntityLiving()).func_70638_az()) > (float)effectLevel) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
        if (PotionPotionSickness.INSTANCE.isEnabled() && event.getEntityLiving().field_70173_aa % 8 == 0) {
            Collection potionEffects = event.getEntityLiving().func_70651_bq();
            int positivePotions = 0;
            for (PotionEffect potionEffect : potionEffects) {
                if (potionEffect.func_188419_a() == null || potionEffect.func_188419_a().func_76398_f()) continue;
                ++positivePotions;
            }
            if (positivePotions >= PotionPotionSickness.potionsForSickness) {
                int amplifier = positivePotions - PotionPotionSickness.potionsForSickness;
                event.getEntityLiving().func_70690_d(new PotionEffect((Potion)PotionPotionSickness.INSTANCE, 10, amplifier));
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound persisted = player.getEntityData().func_74775_l("PlayerPersisted");
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
            }
            if (player.field_70173_aa % 11 == 0 && PotionStepup.INSTANCE.isEnabled()) {
                if (!persisted.func_74767_n("potion core - step_up")) {
                    if (player.func_110148_a(PotionCoreAttributes.STEP_HEIGHT).func_111126_e() != PotionCoreAttributes.STEP_HEIGHT.func_111110_b()) {
                        persisted.func_74757_a("potion core - step_up", true);
                    }
                } else {
                    player.field_70138_W = (float)player.func_110148_a(PotionCoreAttributes.STEP_HEIGHT).func_111126_e();
                    if (player.func_110148_a(PotionCoreAttributes.STEP_HEIGHT).func_111126_e() == PotionCoreAttributes.STEP_HEIGHT.func_111110_b()) {
                        persisted.func_74757_a("potion core - step_up", false);
                    }
                }
            }
            if (PotionFlight.INSTANCE.isEnabled() && player.func_70644_a((Potion)PotionFlight.INSTANCE)) {
                if (!persisted.func_74767_n("potion core - flight")) {
                    persisted.func_74757_a("potion core - flight", true);
                }
                player.field_71075_bZ.field_75101_c = true;
            } else if (persisted.func_74767_n("potion core - flight")) {
                persisted.func_74757_a("potion core - flight", false);
                player.field_70143_R = 0.0f;
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75100_b = false;
                    player.field_71075_bZ.field_75101_c = false;
                }
            }
            if (PotionTeleportSpawn.INSTANCE.isEnabled() && player.func_70644_a((Potion)PotionTeleportSpawn.INSTANCE)) {
                int spawnDelay = persisted.func_74762_e("potion core - spawn teleport");
                if (Math.abs(persisted.func_74769_h("potion core - spawn teleport x") - player.field_70165_t) > 0.01 || Math.abs(persisted.func_74769_h("potion core - spawn teleport y") - player.field_70163_u) > 0.01 || Math.abs(persisted.func_74769_h("potion core - spawn teleport z") - player.field_70161_v) > 0.01) {
                    persisted.func_74780_a("potion core - spawn teleport x", player.field_70165_t);
                    persisted.func_74780_a("potion core - spawn teleport y", player.field_70163_u);
                    persisted.func_74780_a("potion core - spawn teleport z", player.field_70161_v);
                    spawnDelay = 0;
                }
                if (spawnDelay++ >= PotionTeleportSpawn.teleportDelay * 20) {
                    double initialX = player.field_70165_t;
                    double initialY = player.field_70163_u;
                    double initialZ = player.field_70161_v;
                    if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
                        int dimension = player.field_70170_p.field_73011_w.getDimension();
                        WorldServer world = player.field_70170_p.func_73046_m().func_71218_a(dimension);
                        if (world == null) {
                            dimension = 0;
                        } else if (!world.field_73011_w.func_76567_e()) {
                            dimension = world.field_73011_w.getRespawnDimension((EntityPlayerMP)player);
                        }
                        world = player.field_70170_p.func_73046_m().func_71218_a(dimension);
                        BlockPos blockpos = player.getBedLocation(dimension);
                        if (blockpos != null) {
                            blockpos = EntityPlayer.func_180467_a((World)world, (BlockPos)blockpos, (boolean)player.isSpawnForced(dimension));
                        }
                        if (blockpos == null) {
                            blockpos = world.func_175694_M();
                            blockpos = world.func_175672_r(blockpos);
                        }
                        PotionCoreTeleporter.teleportPlayer((EntityPlayerMP)player, null, (World)world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.1, (double)blockpos.func_177952_p() + 0.5);
                    }
                    persisted.func_74768_a("potion core - spawn teleport", 0);
                    player.func_184589_d((Potion)PotionTeleportSpawn.INSTANCE);
                    if (!player.field_70170_p.field_72995_K) {
                        int maxParticles = 128;
                        for (int i = 0; i < maxParticles; ++i) {
                            double scale = (double)i / ((double)maxParticles - 1.0);
                            double motion = (player.func_70681_au().nextFloat() - 0.5f) * 0.5f;
                            double posX = initialX + (player.field_70165_t - initialX) * scale + (player.func_70681_au().nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                            double posY = initialY + (player.field_70163_u - initialY) * scale + player.func_70681_au().nextDouble() * (double)player.field_70131_O;
                            double posZ = initialZ + (player.field_70161_v - initialZ) * scale + (player.func_70681_au().nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                            PotionCoreEventHandler.spawnParticle(player.field_70170_p, EnumParticleTypes.PORTAL, posX, posY, posZ, motion);
                        }
                        player.field_70170_p.func_184148_a(null, initialX, initialY, initialZ, SoundEvents.field_187544_ad, player.func_184176_by(), 1.0f, 1.0f);
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187544_ad, player.func_184176_by(), 1.0f, 1.0f);
                    }
                } else {
                    int particles = spawnDelay == 1 ? 0 : MathHelper.func_76143_f((double)((double)spawnDelay / 10.0));
                    for (int i = 0; i < particles; ++i) {
                        PotionCoreEventHandler.spawnParticle(player.field_70170_p, EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t + (double)(player.func_70681_au().nextFloat() * 2.0f) - 1.0, player.field_70163_u + (double)(player.func_70681_au().nextFloat() * 8.0f), player.field_70161_v + (double)(player.func_70681_au().nextFloat() * 2.0f) - 1.0, 0.0);
                    }
                    persisted.func_74768_a("potion core - spawn teleport", spawnDelay);
                }
            } else if (persisted.func_74762_e("potion core - spawn teleport") > 0) {
                persisted.func_74768_a("potion core - spawn teleport", 0);
            }
            if (player.field_70170_p.field_72995_K && event.getEntityLiving().getEntityData().func_74767_n("Potion Core - Jump Boost Jumping")) {
                boolean isJumping = (Boolean)ObfuscationReflectionHelper.getPrivateValue(EntityLivingBase.class, (Object)player, (String[])new String[]{"isJumping", "field_70703_bu"});
                double height = player.getEntityData().func_74769_h("Potion Core - Jump Boost Height");
                double base = player.getEntityData().func_74769_h("Potion Core - Jump Boost Base");
                if (isJumping && player.field_70163_u > player.field_70167_r && player.field_70163_u - base + 1.0 < height) {
                    player.field_70181_x = 0.45f;
                } else {
                    event.getEntityLiving().getEntityData().func_74757_a("Potion Core - Jump Boost Jumping", false);
                }
            }
        }
    }

    private static void spawnParticle(World world, EnumParticleTypes type, double x, double y, double z, double motion) {
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            worldServer.func_180505_a(type, false, x, y, z, 1, 0.0, 0.0, 0.0, motion, new int[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (PotionRevival.INSTANCE.isEnabled() && event.getEntityLiving().func_70644_a((Potion)PotionRevival.INSTANCE)) {
            int level = event.getEntityLiving().func_70660_b((Potion)PotionRevival.INSTANCE).func_76458_c() + 1;
            event.setCanceled(true);
            event.getEntityLiving().func_70606_j(PotionRevival.reviveHealth * (float)level);
            event.getEntityLiving().field_70170_p.func_184148_a((EntityPlayer)null, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, SoundEvents.field_187802_ec, event.getEntityLiving().func_184176_by(), 1.0f, 0.6f);
            PacketBuffer out = new PacketBuffer(Unpooled.buffer());
            out.writeInt(3);
            out.writeInt(event.getEntityLiving().func_145782_y());
            SToCMessage packet = new SToCMessage((ByteBuf)out);
            PotionCore.networkWrapper.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(event.getEntityLiving().field_70170_p.field_73011_w.getDimension(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, 16.0));
            event.getEntityLiving().func_184589_d((Potion)PotionRevival.INSTANCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLiving entity;
        if (event.getEntity() instanceof EntityLiving && (entity = (EntityLiving)event.getEntity()).func_70638_az() != null && event.getTarget() != null && ConfigLoader.fixBlindness && entity.func_70644_a(MobEffects.field_76440_q)) {
            int effectLevel = 3 - entity.func_70660_b(MobEffects.field_76440_q).func_76458_c();
            if (effectLevel < 0) {
                effectLevel = 0;
            }
            if (entity.func_70032_d((Entity)event.getTarget()) > (float)effectLevel) {
                entity.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            PacketBuffer out = new PacketBuffer(Unpooled.buffer());
            out.writeInt(4);
            PotionCore.networkWrapper.sendTo((IMessage)new SToCMessage((ByteBuf)out), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)event.getEntity();
            if (ConfigLoader.fixChangingDimensions && !event.getWorld().field_72995_K) {
                PotionCoreEventHandler.updateEntityModifiers(entityLiving);
            }
            if (!entityLiving.getEntityData().func_74767_n("Potion Core - Jump Boost Updated") && entityLiving.func_110148_a(PotionCoreAttributes.JUMP_HEIGHT) != null) {
                if (entityLiving.func_110148_a(PotionCoreAttributes.JUMP_HEIGHT).func_111125_b() == 0.0) {
                    entityLiving.func_110148_a(PotionCoreAttributes.JUMP_HEIGHT).func_111128_a(1.0);
                }
                entityLiving.getEntityData().func_74757_a("Potion Core - Jump Boost Updated", true);
            }
        }
    }

    private static void updateEntityModifiers(EntityLivingBase entity) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = entity.func_184582_a(slot);
            if (stack.func_190926_b()) continue;
            entity.func_110140_aT().func_111147_b(stack.func_111283_C(slot));
        }
        if (entity.getEntityData().func_74764_b("Potion Core - Health Fix")) {
            entity.func_70606_j(entity.getEntityData().func_74760_g("Potion Core - Health Fix"));
        } else {
            entity.func_70606_j(entity.func_110138_aP());
            entity.getEntityData().func_74776_a("Potion Core - Health Fix", entity.func_110143_aJ());
        }
        if (entity instanceof EntityPlayerMP) {
            entity.getEntityData().func_74776_a("Potion Core - Health Fix Delay", 5.0f);
            PotionCoreHelper.playersToHeal.add((EntityPlayerMP)entity);
        }
        ArrayList<PotionEffect> effectList = new ArrayList<PotionEffect>();
        for (PotionEffect effect : entity.func_70651_bq()) {
            effectList.add(effect);
        }
        for (PotionEffect effect : effectList) {
            if (effect.func_188419_a() == null) continue;
            effect.func_188419_a().func_111187_a(entity, entity.func_110140_aT(), effect.func_76458_c());
            effect.func_188419_a().func_111185_a(entity, entity.func_110140_aT(), effect.func_76458_c());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!PotionCoreHelper.playersToHeal.isEmpty()) {
                Iterator<EntityPlayerMP> it = PotionCoreHelper.playersToHeal.iterator();
                while (it.hasNext()) {
                    EntityPlayerMP player = it.next();
                    if (player.field_70170_p.field_72995_K) continue;
                    int delay = player.getEntityData().func_74762_e("Potion Core - Health Fix Delay");
                    if (delay < 0) {
                        player.getEntityData().func_74768_a("Potion Core - Health Fix Delay", delay - 1);
                        continue;
                    }
                    player.func_71118_n();
                    player.getEntityData().func_74768_a("Potion Core - Health Fix Delay", -1);
                    it.remove();
                }
            }
            PotionCoreEventHandler.checkInvulReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInvulReset() {
        Object object = INVUL_RESET_LOCK;
        synchronized (object) {
            if (!PotionCoreHelper.invulResetEntities.isEmpty()) {
                PotionCoreHelper.invulResetEntities.forEach(entity -> {
                    entity.field_70172_ad = 0;
                });
            }
            PotionCoreHelper.invulResetEntities.clear();
        }
    }
}

